<?php

namespace App\Models\Task;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Task extends Model 
{

    protected $table = 'tasks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('task_description', 'execution_date', 'task_status', 'assignee', 'employee_id');

    public function user()
    {
        return $this->belongsTo('User');
    }

}